function writeparam(mpar,filename)
% function writeparam(mpar,filename)
%
% write the model parameters mpar into file
% (for use with realtime PD synthesizer)
%
% file format:
% bytes   | content
% --------+------------------------------
% 0-7     | ID: "fassffsp" meaning:
%         | Fractal Additive Synthesis
%         | Sound File Format, 
%         | Single Pitch
% 8-9     | # of partials
% 10-11   | # of WT scales
% 12-13   | # of taps in the WT
% 14-17   | length of signal in samples
%         | (int32)
% 18-?    | g (float[])
%         | h (float[])
% --------+------------------------------
%         | then, for each partial:
%         | P (int16)
%         | k (int16)
%         | Il/Ir (float)
%         | length(sinampcoefs) (int16)
%         | sinampcoefs (float[])
%         | length(sinphasecoefs) (int16)
%         | sinphasecoefs (float[])
%         | length(lpccoefs1left) (int16)
%         | normalisation factor  (float)
%         | lpccoefs1left (float[])
%         | etc. (see report page 83)

normEstLen=1000;

if length(filename)<5 | strcmp(filename(end-4:end),'.fass')==0
    filename=[filename,'.fass'];
end

if strcmp(mpar,'allspline')==0
    ['envelope type must be "allspline"']
else
    fid=fopen(filename,'wb');
	% write identifier for single pitch sound
	% (allow extension for multi pitch sounds
	fwrite(fid,'fassffsp');
	% determine number of partials and scales
	[h,w]=size(mpar);
	partials=w-1
	scales  =(h-5)/4
	% get g and h
	g=mpar{4,end};
	h=mpar{3,end};
	WTtaps=length(g)
	% write # of partials
	fwrite(fid,partials,'int16');
	% write # of scales
	fwrite(fid,scales,'int16');
	% write # of taps
	fwrite(fid,WTtaps,'int16');
	% write length of signal
	fwrite(fid,mpar{1,end},'int32');
	% write g and h
	fwrite(fid,g,'float32');
	fwrite(fid,h,'float32');
	for i=1:partials
%        fwrite(fid,['Partial number ',num2str(i)]);
        % write P,k
        fwrite(fid,mpar{1,i},'int16');
        fwrite(fid,mpar{2,i},'int16');
        % write Il/Ir
        fwrite(fid,mpar{3,i},'float32');
        % write sinampcoef
        fwrite(fid,length(mpar{4,i}.coefs),'int16');
        fwrite(fid,mpar{4,i}.coefs,'float32');
        % write sinphasecoef
        fwrite(fid,length(mpar{5,i}.coefs),'int16');
        fwrite(fid,mpar{5,i}.coefs,'float32');
        for j=1:scales
            % write left lpccoef
            lpccoef=real(mpar{j*4+2,i});
            lpccoef=-lpccoef(2:end);
            fwrite(fid,length(lpccoef),'int16');
            fwrite(fid,lpccoef,'float32');
            % write left normalisation factor
            norm=1/std(filter(1,mpar{j*4+2},randn(1,normEstLen)));
            fwrite(fid,lpccoef,'float32');
            % write left ampcoef
            fwrite(fid,length(mpar{j*4+3,i}.coefs),'int16');
            fwrite(fid,mpar{j*4+3,i}.coefs,'float32');
            % write right lpccoef
            lpccoef=real(mpar{j*4+4,i});
            lpccoef=-lpccoef(2:end);
            fwrite(fid,length(lpccoef),'int16');
            fwrite(fid,lpccoef,'float32');
            % write right normalisation factor
            norm=1/std(filter(1,mpar{j*4+4},randn(1,normEstLen)));
            fwrite(fid,lpccoef,'float32');
            % write right ampcoef
            fwrite(fid,length(mpar{j*4+5,i}.coefs),'int16');
            fwrite(fid,mpar{j*4+5,i}.coefs,'float32');
        end
%        fwrite(fid,['End partial number ',num2str(i)]);        
	end
	fclose(fid);
end