// Auto-Regressive Filter
// (For LPC resynthesis)

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangeli sta]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.


#include "m_pd.h"
#include "pd_ringbuffer.h"

static t_class *ARF_class;

typedef struct _ARF {
  t_object x_obj;

  t_rb_info *outbuffer;
  t_float   *coef;
} t_ARF;

// constructor
void *ARF_new(void)
{
  t_ARF *x=(t_ARF *)pd_new(ARF_class);
  
  inlet_new(&x->x_obj, &x->x_obj.ob_pd,
            &s_list, &s_list);
  
  outlet_new(&x->x_obj, &s_float);
  
  // set outbuffer and coefs to null pointer
  x->outbuffer = 0;
  x->coef      = 0;
  
  return (void *)x;
}

// destructor
void ARF_free(t_ARF *x) {
  // if old buffers exist, deallocate their memory
  // free the memory for coefficients
  if (x->coef!=0)
    freebytes(x->coef, x->outbuffer->size*sizeof(t_float));
  // destroy the output buffer
  if (x->outbuffer!=0)
    rb_destroy(x->outbuffer);
}

void ARF_coef(t_ARF *x, t_symbol *s, int argc, t_atom *argv)
{
  t_int i;
  
  // if old buffers exist, free them
  ARF_free(x);
  // allocate new buffer for argc output samples
  // and just as many coefficients
  x->coef=getbytes(argc*sizeof(t_float));
  x->outbuffer=rb_create(argc);
  flrb_init(x->outbuffer);
  
  // fill coef with the atoms from the list
  // (in reverse order for flrb_conv)
  for (i=0; i<argc; i++) {
    x->coef[i]=atom_getfloat(&(argv[argc-1-i]));
  }
}

void ARF_sig(t_ARF *x, t_floatarg f)
{
  t_float output;
  
  if (x->outbuffer!=0) {
    output=f+flrb_conv(x->outbuffer, x->coef);
    flrb_put(x->outbuffer, output);
    outlet_float(x->x_obj.ob_outlet, output);
  }
}

void ARF_setup(void) {
  ARF_class = class_new(gensym("ARF"),
                         (t_newmethod)ARF_new,
			 (t_method)ARF_free,
                         sizeof(t_ARF),
			 CLASS_DEFAULT, 0);
  class_addfloat(ARF_class, ARF_sig);
  class_addlist(ARF_class, (t_method)ARF_coef);
}

