// Delay for float messages.
// Delay is given by object parameter or right inlet
// Default value: 1

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangelista]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.

#include "m_pd.h"
#include "pd_ringbuffer.h"

static t_class *fdelay_class;

#define SQRT2  1.4142135624
#define ISQRT2 0.7071067812

typedef struct _fdelay {
  t_object  x_obj;
  t_rb_info *buf;
} t_fdelay;

void fdelay_float(t_fdelay *x, t_floatarg f)
{
  t_float output;
  
  output=flrb_get(x->buf);
  flrb_put(x->buf, f);
  outlet_float(x->x_obj.ob_outlet, output);
}

void fdelay_adjust(t_fdelay *x, t_floatarg D)
{
  t_int D_int=(t_int)D;
  
  if (D_int<1) {
    D_int=1;
    post("fdelay: invalid delay (using 1)");
  }
  
  // destroy buffer and create a new one if needed
  if (D_int!=x->buf->size) {
    rb_destroy(x->buf);
    x->buf=rb_create(D_int);
  }
  // initialize buffer to 0's
  flrb_init(x->buf);
}

void *fdelay_new(t_floatarg D)
{
  t_int D_int=(t_int)D;
  
  t_fdelay *x=(t_fdelay *)pd_new(fdelay_class);
  
  if (D_int<1)
    D_int=1;
    
  post("Delay: %d",D_int);
    
  x->buf=rb_create(D_int);
  flrb_init(x->buf);
  
  inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_float, gensym("adjust"));
  
  outlet_new(&x->x_obj, &s_float);
  
  return (void *)x;
}

void fdelay_free(t_fdelay *x)
{
  rb_destroy(x->buf);
}

void fdelay_setup(void) {
  fdelay_class = class_new(gensym("fdelay"),
                         (t_newmethod)fdelay_new,
			 (t_method)fdelay_free,
                         sizeof(t_fdelay),
			 CLASS_DEFAULT,
                         A_DEFFLOAT, 0);
  class_addfloat(fdelay_class, fdelay_float);
  class_addmethod(fdelay_class, (t_method)fdelay_adjust,
                  gensym("adjust"), A_DEFFLOAT, 0);
}

