// Message dropper for float messages. 
// Drop count is given by object parameter or right inlet
// Default value: 0

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangelista]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.

#include "m_pd.h"

static t_class *fdrop_class;

#define SQRT2  1.4142135624
#define ISQRT2 0.7071067812

typedef struct _fdrop {
  t_object x_obj;
  t_int    count;
} t_fdrop;

void fdrop_float(t_fdrop *x, t_floatarg f)
{
  if (x->count>0) {
    x->count--;
  } else
    outlet_float(x->x_obj.ob_outlet, f);
}

void fdrop_adjust(t_fdrop *x, t_floatarg count)
{
  t_int count_int=(t_int)count;
  
  if (count_int<0) {
    count_int=0;
    post("fdrop: invalid count (using 0)");
  }
  
  x->count=count_int;
}

void *fdrop_new(t_floatarg count)
{
  t_int count_int=(t_int)count;
  
  t_fdrop *x=(t_fdrop *)pd_new(fdrop_class);
  
  if (count_int<0) {
    count_int=0;
    post("fdrop: invalid count (using 0)");
  }
  
  x->count=count_int;
  
  inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_float, gensym("adjust"));
  
  outlet_new(&x->x_obj, &s_float);
  
  return (void *)x;
}

void fdrop_setup(void) {
  fdrop_class = class_new(gensym("fdrop"),
                         (t_newmethod)fdrop_new,
			 0,
                         sizeof(t_fdrop),
			 CLASS_DEFAULT,
                         A_DEFFLOAT, 0);
  class_addfloat(fdrop_class, fdrop_float);
  class_addmethod(fdrop_class, (t_method)fdrop_adjust,
                  gensym("adjust"), A_DEFFLOAT, 0);
}

