// Float-message-to-signal converter
// Useful for transforming audio signals
// with modules like WT, IWT, etc.
// 
// Copyright (C) 2002, Fritz Menzer
// http://www.xsmusic.ch

#include "m_pd.h"
#include "pd_ringbuffer.h"
#include "math.h"

#define P_MAX 5000
#define P_MIN 64

static t_class *float2sig_tilde_class;

typedef struct _float2sig_tilde {
  t_object  x_obj;
  t_rb_info *inbuffer;
} t_float2sig_tilde;

// write incoming float numbers into buffer
void float2sig_tilde_float(t_float2sig_tilde *x, t_floatarg f)
{
  flrb_put(x->inbuffer, f);
}

t_int *float2sig_tilde_perform(t_int *w)
{
  t_float2sig_tilde *x = (t_float2sig_tilde *)(w[1]);
  t_sample   *out =     (t_sample *)(w[2]);
  t_int         n =          (t_int)(w[3]);
  t_int i;
  t_float *buffer = x->inbuffer->start;

  for (i=0; i < x->inbuffer->size - x->inbuffer->write_ptr; i++)
    *out++ = buffer[i+x->inbuffer->write_ptr];
  // iresp : size-write_ptr -> size-1
  // buffer: 0              -> write_ptr-1
  for (i=0; i < x->inbuffer->write_ptr; i++)
    *out++ = buffer[i];
      
  return (w+4);
}

void float2sig_tilde_dsp(t_float2sig_tilde *x, t_signal **sp)
{
  dsp_add(float2sig_tilde_perform, 3, x,
          sp[0]->s_vec,sp[0]->s_n);
}

// constructor
void *float2sig_tilde_new(t_floatarg P, t_floatarg k)
{
  t_float2sig_tilde *x = (t_float2sig_tilde *)pd_new(float2sig_tilde_class);

  // create input buffer
  x->inbuffer=rb_create(64);
  
  flrb_init(x->inbuffer);
  
  // signal outlet
  outlet_new(&x->x_obj, &s_signal);
  
  return (void *)x;
}

// destructor
void float2sig_tilde_free(t_float2sig_tilde *x)
{
  rb_destroy(x->inbuffer);
}

void float2sig_tilde_setup(void) {
  float2sig_tilde_class = class_new(gensym("float2sig~"),
        (t_newmethod)float2sig_tilde_new,
	(t_method)float2sig_tilde_free,
        sizeof(t_float2sig_tilde),
	CLASS_DEFAULT, 0);
  
  class_addfloat(float2sig_tilde_class, float2sig_tilde_float);
  class_addmethod(float2sig_tilde_class,
        (t_method)float2sig_tilde_dsp, gensym("dsp"), 0);
}
