// Haar two-channel filterbank

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangelista]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.

#include "m_pd.h"

static t_class *haar_class;

#define SQRT2  1.4142135624
#define ISQRT2 0.7071067812

typedef struct _haar {
  t_object x_obj;
  t_float  last_in;
  t_int    last_in_valid;
  t_outlet *high_out;
  t_outlet *low_out;
} t_haar;

void haar_float(t_haar *x, t_floatarg f)
{
  if (x->last_in_valid) {
    x->last_in_valid = 0;
    outlet_float(x->high_out, ISQRT2*(x->last_in-f));
    outlet_float(x->low_out,  ISQRT2*(x->last_in+f));
  } else {
    x->last_in = f;
    x->last_in_valid = 1;
  }
}

void *haar_new(void)
{
  t_haar *x=(t_haar *)pd_new(haar_class);
  
  x->low_out  = outlet_new(&x->x_obj, &s_float);
  x->high_out = outlet_new(&x->x_obj, &s_float);
  
  x->last_in_valid = 0;
  
  return (void *)x;
}

void haar_setup(void) {
  haar_class = class_new(gensym("haar"),
                         (t_newmethod)haar_new,
			 0, sizeof(t_haar),
			 CLASS_DEFAULT, 0);
  class_addfloat(haar_class, haar_float);
}

