// Inverse Haar twochannel filterbank
// (for constructing wavelet transforms)

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangelista]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.

#include "m_pd.h"
#include "pd_ringbuffer.h"

static t_class *ihaar_class;

#define SQRT2  1.4142135624
#define ISQRT2 0.7071067812

typedef struct _ihaar {
  t_object x_obj;

  t_rb_info *high_buffer;
  t_rb_info *low_buffer;
} t_ihaar;

void ihaar_high(t_ihaar *x, t_floatarg f)
{
  t_float low_in;
  if (x->low_buffer->is_empty==0) {
    low_in=airb_get(x->low_buffer);
    outlet_float(x->x_obj.ob_outlet, ISQRT2*(low_in+f));
    outlet_float(x->x_obj.ob_outlet, ISQRT2*(low_in-f));
  } else {
    airb_put(x->high_buffer,f);
  }
}

void ihaar_low(t_ihaar *x, t_floatarg f)
{
  t_float high_in;
  if (x->high_buffer->is_empty==0) {
    high_in=airb_get(x->high_buffer);
    outlet_float(x->x_obj.ob_outlet, ISQRT2*(f+high_in));
    outlet_float(x->x_obj.ob_outlet, ISQRT2*(f-high_in));
  } else {
    airb_put(x->low_buffer,f);
  }
}

void *ihaar_new(void)
{
  t_ihaar *x=(t_ihaar *)pd_new(ihaar_class);
  
  inlet_new(&x->x_obj, &x->x_obj.ob_pd,
            &s_float, gensym("high"));
  
  outlet_new(&x->x_obj, &s_float);
  
  x->high_buffer = rb_create(1);
  x->low_buffer  = rb_create(1);
  
  return (void *)x;
}

void ihaar_setup(void) {
  ihaar_class = class_new(gensym("ihaar"),
                         (t_newmethod)ihaar_new,
			 0, sizeof(t_ihaar),
			 CLASS_DEFAULT, 0);
  class_addfloat(ihaar_class, ihaar_low);
  class_addmethod(ihaar_class, (t_method)ihaar_high, 
                  gensym("high"), A_DEFFLOAT, 0);
}

