// List Minimum and Maximum
// (For scaling array data)

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangelista]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.

#include "m_pd.h"

static t_class *listminmax_class;

typedef struct _listminmax {
  t_object x_obj;
  
  t_outlet *minout,*maxout;
} t_listminmax;

// constructor
void *listminmax_new(void)
{
  t_listminmax *x=(t_listminmax *)pd_new(listminmax_class);
  
  x->minout = outlet_new(&x->x_obj, &s_float);
  x->maxout = outlet_new(&x->x_obj, &s_float);
  
  return (void *)x;
}

void listminmax_in(t_listminmax *x, t_symbol *s, int argc, t_atom *argv)
{
  t_int i;
  t_float min, max, elem;
  
  if (argc>0) {
    min=atom_getfloat(&argv[0]);
    max=atom_getfloat(&argv[0]);
    if (argc>1) for (i=1;i<argc;i++) {
      elem=atom_getfloat(&argv[i]);
      if (elem>max)
        max=elem;
      if (elem<min)
        min=elem;
    }
    outlet_float(x->minout,min);
    outlet_float(x->maxout,max);
  }
}

void listminmax_setup(void) {
  listminmax_class = class_new(gensym("listminmax"),
                         (t_newmethod)listminmax_new,
			 0,
                         sizeof(t_listminmax),
			 CLASS_DEFAULT, 0);
  class_addlist(listminmax_class, (t_method)listminmax_in);
}

