// normalized tabread4 (input: always between 0 and 1,
// independently of the array size)

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangelista]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.

#include "m_pd.h"

static t_class *ntr4_class;

typedef struct _ntr4
{
    t_object x_obj;
    t_symbol *x_arrayname;
} t_ntr4;

void ntr4_float(t_ntr4 *x, t_float f)
{
    t_garray *ar;
    int npoints,n;
    t_float *vec;
	t_float f_extended;
    float a, b, c, d, frac, out, *fp;

    if (!(ar = (t_garray *)pd_findbyclass(x->x_arrayname, garray_class)))
    {
    	error("%s: no such array", x->x_arrayname->s_name);
        return;
    }
    if (!garray_getfloatarray(ar, &npoints, &vec))
    {
    	error("%s: bad template for ntr4", x->x_arrayname->s_name);
        return;
    }
    if (npoints < 4)
    {
	outlet_float(x->x_obj.ob_outlet, 0);
        return;
    }
    
    f_extended = f * (npoints-1);
    n          = f_extended;
    
    if (f <= 0)
    	outlet_float(x->x_obj.ob_outlet, vec[0]);
    else if (f >= 1)
    	outlet_float(x->x_obj.ob_outlet, vec[npoints - 1]);
    else
    {
	if (n < 1)
	    n = 1;
	else if (n >= npoints - 2)
	    n = npoints - 3;
	fp = vec + n;
	frac = f_extended - n;
	a = fp[0]/2. - fp[1]/2. - fp[-1]/6. + fp[2]/6.;
	b =-fp[0]    + fp[1]/2. + fp[-1]/2.;
	c =-fp[0]/2. + fp[1]    - fp[-1]/3. - fp[2]/6.;
	d = fp[0];
	outlet_float(x->x_obj.ob_outlet, 
                     d+c*frac+b*frac*frac+a*frac*frac*frac);
    }
}

void ntr4_set(t_ntr4 *x, t_symbol *s)
{
    x->x_arrayname = s;
}

void *ntr4_new(t_symbol *s)
{
    t_ntr4 *x = (t_ntr4 *)pd_new(ntr4_class);
    x->x_arrayname = s;
    outlet_new(&x->x_obj, &s_float);
    return (x);
}

void ntr4_setup(void)
{
    ntr4_class = class_new(gensym("ntr4"), (t_newmethod)ntr4_new,
    	0, sizeof(t_ntr4), 0, A_DEFSYM, 0);
    class_addfloat(ntr4_class, (t_method)ntr4_float);
    class_addmethod(ntr4_class, (t_method)ntr4_set, gensym("set"),
    	A_SYMBOL, 0);
}

