#ifndef MAXPDSTRING
#include "m_pd.h"
#endif

// Ringbuffer for floating-point numbers
// using only PD data types

// This File is part of the 
// Fractal Additive Synthesis Tools for Pure Data

// Copyright (C) 2002, Fritz Menzer
// Ecole Polytechnique Fdrale de Lausanne
// (EPFL)

// Fractal Additive Synthesis Technology:
// Copyright (C) Pietro Polotti and Gianpaolo Evangelista
// Laboratoire de Communications Audiovisuelles
// (LCAV)
// cole Polytechnique Fdrale de Lausanne
// DSC-INR, Ecublens
// CH-1015, Lausanne, Switzerland
// [pietro.polotti,gianpaolo.evangeli sta]@epfl.ch

// You are free to use this code for any non-commercial purpose,
// provided that the above copyright notices are included in any
// software, hardware or publication derived from this code.


// Two types of buffers are implemented:
//   Auto-increase (prefix: airb_):
//     Dynamically increases the buffer length as needed,
//     Methods: put, get
//   Fixed-length (function prefix: flrb_):
//     length of buffer is fix,
//     write pointer serves also as read pointer
//     Methods: put, get, conv (convolution), mult_add

// MS VC++ allows inline functions only in C++ and not in C,
// so let's #define it away
#ifdef NT
#define inline
#endif

typedef struct _rb_info {
  // start address
  t_float  *start;
  // buffersize in floating point numbers
  t_int    size;
  // write pointer (points to the element to be written next)
  t_int    write_ptr;
  // read pointer (points to the element to be read next)
  t_int    read_ptr;
  // indicates that the buffer is empty
  t_int    is_empty;
} t_rb_info;

// creates a new ringbuffer for size numbers
t_rb_info *rb_create(size_t size);

// frees all memory occupied by the buffer
// (including info field)
void rb_destroy(t_rb_info *info);

// initialises to 0 the whole buffer
void flrb_init(t_rb_info *info);

// returns 1 of buffer is empty, 0 otherwise
inline t_int airb_is_empty(t_rb_info *info);

// puts a floating-point number into the buffer
// (overwriting whatever was there before)
inline void flrb_put(t_rb_info *info, t_float f);

// gets a floating-point number from the buffer
// (not moving the write pointer)
inline t_float flrb_get(t_rb_info *info);

// calculates the convolution between the buffer content
// and iresp (supposed to have the same length as the buffer)
// ATTENTION: iresp is the time-reversed impulse response
inline t_float flrb_conv(t_rb_info *info, t_float *iresp);

// adds the impulse response iresp, multiplied by coef, to
// the buffer
inline void flrb_mult_add(t_rb_info *info, t_float *iresp,
                             t_float coef);

// puts a float into the buffer specified by info
// and automatically increases the buffer size
// in order to avoid buffer overflows
inline void airb_put(t_rb_info *info, t_float f);

// gets a float from the buffer specified by info
// ATTENTION: No error-checking for buffer underruns
// (use airb_is_empty before calling this method)
inline t_float airb_get(t_rb_info *info);
