// Signal-to-float-message converter
// Useful for transforming audio signals
// with modules like WT, IWT, etc.
// 
// Copyright (C) 2002, Fritz Menzer
// http://www.xsmusic.ch

#include "m_pd.h"

static t_class *sig2float_tilde_class;

typedef struct _sig2float_tilde {
  t_object x_obj;
  t_sample f;
} t_sig2float_tilde;

t_int *sig2float_tilde_perform(t_int *w)
{
  t_sig2float_tilde *x = (t_sig2float_tilde *)(w[1]);
  t_sample         *in =          (t_sample *)(w[2]);
  int                n =                 (int)(w[3]);
  
  while (n--) 
    outlet_float(x->x_obj.ob_outlet, *in++);  
  
  return (w+4);
}

void sig2float_tilde_dsp(t_sig2float_tilde *x, t_signal **sp)
{
  dsp_add(sig2float_tilde_perform, 3, x,
          sp[0]->s_vec,sp[0]->s_n);
}

void *sig2float_tilde_new(void)
{
  t_sig2float_tilde *x = (t_sig2float_tilde *)pd_new(sig2float_tilde_class);
  
  outlet_new(&x->x_obj, &s_float);
  
  return (void *)x;
}

void sig2float_tilde_setup(void) {
  sig2float_tilde_class = class_new(gensym("sig2float~"),
        (t_newmethod)sig2float_tilde_new,
	0, sizeof(t_sig2float_tilde),
	CLASS_DEFAULT, 0);
  
  class_addmethod(sig2float_tilde_class,
        (t_method)sig2float_tilde_dsp, gensym("dsp"), 0);
  CLASS_MAINSIGNALIN(sig2float_tilde_class, t_sig2float_tilde, f);
}
