function y=cmfb(x,P);
% function y=cmfb(x,P);
%
% calculate the coefficients coming out of a critically
% downsampled cosine modulated filterbank with P channels.
%
% Based on cosine modulated filterbank function by 
% Nino Poloni, Universita` "Federico II" di Napoli, Italia.   
%	

a=sin(((0:P-1)+.5)*pi/2/P);
a(P+1:2*P)=a(P:-1:1);
n=[0:2*P-1]; k=[0:P-1];
W=sqrt(2/P)*a'*ones(1,P).*cos(((2*n'+P+1)*pi)*(2*k+1)/(4*P));
y=upfirdn(x,W(end:-1:1,:),1,P);
 