function sgram=fftspect(s,wlen,disp,wtype)
% function sgram=fftspect(s,wlen,disp,wtype)
%
% spectrogram of s
% window length:        wlen  (default: 1024  )
% window displacement:  disp  (default:  512  )
% window type:          wtype (default: 'hann')

if nargin<4, wtype='hann'; end
if nargin<3, disp=512; end
if nargin<2, wlen=1024; end

slen=length(s);
% determine number of windows
wnum=1+ceil((slen-wlen)/disp);
% determine length of zero-padded signal
szplen=wlen+(wnum-1)*disp;
% zero-pad signal so that it fits an entire number of windows
szp=[s; zeros(szplen-slen,1)];

% generate window
w=eval([wtype,'(',num2str(wlen),')']);

% make empty spectrum
sgram=zeros(wlen,wnum);
for k=0:wnum-1
   sgram(:,k+1)=fft(szp(k*disp+1:k*disp+wlen).*w);
end
