function coef=hbwt(s,P,sc,w);
% function coef=hbwt(s,P,sc,w);
%
% Calculate Harmonic Band Wavelet Transform
% with P bands and sc scales of the wavelet
% transform given by wfilters(w)
% 
% Default values: sc = 3
%                 w  = 'db3'

if nargin<4, w='db3'; end
if nargin<3, sc=3; end

[LO_D,HI_D] = WFILTERS(w);
A=[LO_D',HI_D'];

coef=cell(P,1);
ccoef=cmfb(s,P);
for i=1:P
    coef{i}=wt(ccoef(:,i),A,sc);
end