function y=icmfb(x);
% function y=icmfb(x);
%
% Reconstruct a signal from its CMFB coefficients
%
% Based on cosine modulated filterbank function by 
% Nino Poloni, Universita` "Federico II" di Napoli, Italia.   
%	

 P=size(x,2);
 a=sin(((0:P-1)+.5)*pi/2/P);
 a(P+1:2*P)=a(P:-1:1);
 n=[0:2*P-1]; k=[0:P-1];
 W=sqrt(2/P)*a'*ones(1,P).*cos(((2*n'+P+1)*pi)*(2*k+1)/(4*P));
 y=upfirdn(x(:,1),W(:,1),P);
 y=y(2*P:end,:);
 for k=2:P
     yy=upfirdn(x(:,k),W(:,k),P);
     y=yy(2*P:end,:)+y;
 end       
 