function s=ifftspect(sgram,disp)
% function s=ifftspect(sgram,disp)
%
% calculate signal from spectrogram
% window displacement:  disp

wlen=size(sgram,1);
if nargin<2, disp=wlen; end

% determine number of windows
wnum=size(sgram,2);
% determine length of zero-padded signal
slen=wlen+(wnum-1)*disp;

% make empty spectrum
s=zeros(slen,1);
for k=0:wnum-1
   s((1:wlen)+k*disp)=s((1:wlen)+k*disp)+real(ifft(sgram(:,k+1)));
end
