function s=ihbwt(coef,w);
% function s=ihbwt(coef,w);
%
% Calculate inverse Harmonic Band Wavelet Transform
% using the wavelet transform given by wfilters(w)
% 
% Default value for w = 'db3'

if nargin<2, w='db3'; end

[LO_D,HI_D,LO_R,HI_R] = WFILTERS('db3');
S=[LO_R',HI_R'];

P=length(coef);
cc=iwt(coef{1},S);
ccoef=[cc,zeros(length(cc),P-1)];
for i=2:P
    ccoef(:,i)=iwt(coef{i},S);
end
s=icmfb(ccoef);