function plotfftspect(sgram,disp,start,fs)
% function plotfftspect(sgram,disp,start,fs)
% 
% Plot a spectrogram.
% sgram: matrix representing the spectrogram
%        rows:    frequencies
%        columns: frames
% disp:  displacement of the window
% start: time of the first frame (default: 0)
% fs:    sampling frequency      (default: 44100)

if nargin<4, fs=44100; end
if nargin<3, start=0; end

y=(floor(size(sgram,1)/2):-1:0)/floor(size(sgram,1)/2)/2*fs;
x=(1:size(sgram,2))/fs*disp+start;
imagesc(x,y,log(abs(sgram(floor(size(sgram,1)/2)+1:-1:1,:))));
axis xy;