function plotftwtspect(coef,start,fs)
% function plotftwtspect(coef,start,fs)
% 
% Plot a spectrogram made by a full tree wavelet decomposition.
%
% !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% !!! Please note: Interpreting the y axis as frequencies does not   !!!
% !!! make sense as Wavelets have not much in common with sinusoids. !!!
% !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
%
% coef:  matrix containing the data
%        rows:    frames
%        columns: channels
% disp:  displacement of the window
% start: time of the first frame (default: 0)
% fs:    sampling frequency      (default: 44100)

if nargin<3, fs=44100; end
if nargin<2, start=0; end

coef=coef';
y=(size(coef,1)-1:-1:0); %/(size(coef,1)-1)*fs/2;
x=(1:size(coef,2))*2/fs*size(coef,1)+start;
imagesc(x,y,log(abs(coef(floor(size(coef,1)/2)+1:end,:))));
axis xy;