function plothbwtspect(coef,start,fs)
% function plothbwtspect(coef,start,fs)
% 
% Plot a spectrogram from HBWT coefficients.
% coef:  structure containing the coefficients
%        (produced by hbwt.m)
% start: time of the first frame (default: 0)
% fs:    sampling frequency      (default: 44100)

if nargin<3, fs=44100; end
if nargin<2, start=0; end

P=length(coef);
ws=wtspect(coef{1});
[h,w]=size(ws);
sgram=zeros(h,P*w);
idx=[1:w;w:-1:1];
sgram(:,1:w)=ws(:,w:-1:1);
for i=2:P
    ws=wtspect(coef{i});
    sgram(:,w*(i-1)+1:w*i)=ws(:,idx(mod(i,2)+1,:));
end

y=(0:P*w-1)/(P*w-1)*fs/2;
x=(0:h-1)*2*P/fs+start;
imagesc(x,y,log(abs(sgram')));
axis xy;