function plotibwtspect(ccoef,sc)
% function plotibwtspect(ccoef,sc)
% ### quick hack ###
% Plot a spectrogram from heterogeneous CMFB coefficients.
% coef:  structure containing the cmfb coefficients
%        (produced by makerescoef.m)

fs=44100;
start=0;
[LO_D,HI_D] = WFILTERS('db3');
A=[LO_D',HI_D'];

P=length(ccoef)-1;
coef=cell(P*2,1);
maxlen=0;
maxidx=0;
for i=1:P
    coef{i*2-1}=wt(ccoef{i}(:,1),A,sc);
    coef{i*2}=wt(ccoef{i}(:,2),A,sc);
    if length(ccoef{i})>maxlen
        maxlen=length(ccoef{i});
        maxidx=i*2;
    end
end
P=length(coef);
ws=wtspect(coef{maxidx});
[h,w]=size(ws);
sgram=zeros(h,P*w);
idx=[w:-1:1;1:w];
for i=1:P
    ws=wtspect(coef{i});
    h=size(ws,1);
    sgram(1:h,w*(i-1)+1:w*i)=ws(1:h,idx(mod(i,2)+1,:));
end

y=(0:P*w-1)/(P*w)*fs/2;
x=(0:h-1)*2*P/fs+start;
imagesc(x,y,log(abs(sgram')));
axis xy;